# C Code Language 

Welcome to this GitHub repository that covers the basics of the C programming language. Why the C language? Windows, at its core, is primarily written in C. Being familiar with at least the basics of the C language gives several advantages when it comes down to debugging and troubleshooting on this platform. 

# What is C?

The C programming language is a procedural and general-purpose, computer programming language that was developed in the early 1970s at Bell Labs by Dennis Ritchie.

C is especially well-suited to systems programming due to its low-level access to memory and its set of keywords, which can be compiled on a wide variety of computer platforms. It provides low-level access to memory, a set of keywords, and clean style, making it very useful for system and hardware level programming.

C is mainly used for:

- **OS Development**
- **Embedded Systems**
- **Game Development**
- **Compilers**

# What will we cover?

```
- Section 1: Variables
- Section 2: Operators
- Section 3: Control Flow
- Section 4: Pointers, Arrays and Strings
- Section 5: Structures
- Section 6: Input & Output
- Section 7: Command Line Arguments
- Section 8: Memory Allocation
- Section 9: Linked List
```

# Important

For these sections, since we're using C. Make sure that the source files are ending with the **.c** extension when you are compiling code. Otherwise, you may encounter some issues during the compilation.

![image](https://github.com/DebugPrivilege/InsightEngineering/assets/63166600/757e65c1-b2f4-4c13-ba42-19847cd12882)


# How to Use This Repository?

1. **Navigate:** Go through each topic one by one or jump to the sections you're interested in. However, it is recommended to go through all the sections.
2. **Practice:** Alongside the theory, you'll find practical examples with code snippets. Make sure to compile these code snippets within Visual Studio. This allows you to understand the topic better.

# Contributions

If you find any mistakes or areas of improvement, please feel free to create an issue or submit a pull request.
